package FlashReader;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;

public class Tag2 {
	
	public static ArrayList<Tag2> tags = new ArrayList<Tag2>();
	public static HashMap<Integer,Integer> mapowanie = new HashMap<Integer,Integer>(); //position, id array
	public static ArrayList<Tag2> targets = new ArrayList<Tag2>();//miejsca w kodzie do ktrych prowadza jumpy
	
	public static int codeSize;

	private int opcode;
	private byte[] date;
	private int position;
	private int size;
	private int jump=-1;
	public Tag2 target;
	private int offset;
	
	
	public Tag2(int opcode, byte[] date, int position, int size){
		//if(opcode !=0x02){
			
			mapowanie.put(position, tags.size());
			tags.add(this);
			codeSize+=size;
			this.date = date;
			this.opcode = opcode;
			this.position =position;
			this.size = size;
		//}
	}
	
	public Tag2(int opcode, byte[] date, int position, int size, int jump, int offset){
		//if(opcode !=0x02){
	
			mapowanie.put(position, tags.size());
			tags.add(this);
			codeSize+=size;
			this.date = date;
			this.opcode = opcode;
			this.position =position;
			this.size = size;
			this.jump=jump;
			this.offset = offset;
		//}
	}
	
	
	public int getOffset() {
		return offset;
	}

	public static void initTarget(){
		for (Tag2 t: Tag2.tags){
			if (t.opcode == OP_jump||t.opcode==OP_iftrue ||
					t.opcode==OP_iftrue ||
					t.opcode==OP_iffalse ||
					t.opcode==OP_ifeq ||
					t.opcode==OP_ifnge ||
					t.opcode==OP_ifge ||
					t.opcode==OP_ifnge ||
					t.opcode==OP_ifgt ||
					t.opcode==OP_ifngt ||
					t.opcode==OP_ifle ||
					t.opcode==OP_ifnle ||
					t.opcode==OP_iflt ||
					t.opcode==OP_ifnlt ||
					t.opcode==OP_ifstricteq ||
					t.opcode==OP_ifstrictne||
					t.opcode==OP_ifne ){
			
				Integer pos = null; 
				if (  (pos= mapowanie.get(t.jump))!=null ){
					t.target = tags.get(pos);
					targets.add(t.target);
				}else{
					int poz = t.getPositionId();
					tags.set(poz, null);
				}
				
			}
		}
		
	}

	public int getPosition() {
		return position;
	}
	
	public int getPositionId() {
		return tags.indexOf(this);
	}
	
	public static void clear(){
		tags = new ArrayList<Tag2>();
		mapowanie = new HashMap<Integer,Integer>(); //position, id array
		targets = new ArrayList<Tag2>();//miejsca w kodzie do ktrych prowadza jumpy
	}
	
	/*public static byte[] getBytes(){
		byte result[] = new byte[Tag.codeSize];
		int last =0;
		for (int i =0; i < tags.size();i++){
			System.arraycopy(tags.get(i).date, 0, result, last, tags.get(i).date.length);
			last+= tags.get(i).date.length;
		}
		return result;
	}*/
	
	public static byte[] getBytes(){
		updateOffsetJump();
		ArrayList<Byte> tmp = new ArrayList<Byte>();
		for (int i =0; i < tags.size();i++){
			if ( tags.get(i)!=null &&tags.get(i).date !=null){
				for (int j =0; j < tags.get(i).date.length;j++){
					tmp.add(tags.get(i).date[j]);
				}
				
			}
		}
		byte result[] = new byte[tmp.size()];
		
		for (int i =0; i < tmp.size();i++){
			result[i] = tmp.get(i);
		}
		return result;
	
	}
	
	
	
	public void setJumpPos(int jump) {
		this.jump = jump;
		ByteBuffer bbuf = ByteBuffer.allocate(4);
		bbuf.order(ByteOrder.LITTLE_ENDIAN);
		bbuf.putInt(jump);
		bbuf.position(0);
		for (int i=0; i < 3;i++){
			date[i+1] = bbuf.get();
		}
		position = jump;
	}
	
	/*public void setJumpId(int id) {
		this.jump = mapowanie.get(id);
		ByteBuffer bbuf = ByteBuffer.allocate(4);
		bbuf.order(ByteOrder.LITTLE_ENDIAN);
		bbuf.putInt(jump);
		bbuf.position(0);
		for (int i=0; i < 3;i++){
			date[i+1] = bbuf.get();
		}
	}*/

	public int getJumpPos() {
		return jump;
	}
	
	public int getJumpId() {
		return tags.indexOf(target);
		
	}

	public void setTarget(Tag2 target) {
		this.target = target;
	}

	public int getOpcode() {
		return opcode;
	}

	public Tag2 getTarget() {
		return target;
	}
	
	public static void updateOffsetJump(){
		int suma1 =0;
		for (int i =0; i <tags.size();i++){
			if (tags.get(i) !=null ){
				
				suma1+=tags.get(i).date.length;
				if (tags.get(i).getOpcode()==0x10 ||Tag2.tags.get(i).getOpcode()==OP_iftrue ||
						Tag2.tags.get(i).getOpcode()==OP_iftrue ||
						Tag2.tags.get(i).getOpcode()==OP_iffalse ||
						Tag2.tags.get(i).getOpcode()==OP_ifeq ||
						Tag2.tags.get(i).getOpcode()==OP_ifnge ||
						Tag2.tags.get(i).getOpcode()==OP_ifge ||
						Tag2.tags.get(i).getOpcode()==OP_ifnge ||
						Tag2.tags.get(i).getOpcode()==OP_ifgt ||
						Tag2.tags.get(i).getOpcode()==OP_ifngt ||
						Tag2.tags.get(i).getOpcode()==OP_ifle ||
						Tag2.tags.get(i).getOpcode()==OP_ifnle ||
						Tag2.tags.get(i).getOpcode()==OP_iflt ||
						Tag2.tags.get(i).getOpcode()==OP_ifnlt ||
						Tag2.tags.get(i).getOpcode()==OP_ifstricteq ||
						Tag2.tags.get(i).getOpcode()==OP_ifstrictne ||
						Tag2.tags.get(i).getOpcode()==OP_ifne){
					
					
					int idJump = tags.indexOf(tags.get(i).target);
					
					int suma2=0;
					for (int j =0; j < idJump;j++){
						if( tags.get(j)!=null){
							suma2+=tags.get(j).date.length;
						}
					}
					int offset = suma2-suma1;
					
					tags.get(i).setJumpPos(offset);
					
				}
			
			}
		}
	}
	
	public byte[] getDate() {
		return date;
	}

	private final static int OP_ifnlt = 0x0C;
	private final static int OP_ifnle = 0x0D;
	private final static int OP_ifngt = 0x0E;
	private final static int OP_ifnge = 0x0F;
	private final static int OP_jump = 0x10;
	private final static int OP_iftrue = 0x11;
	private final static int OP_iffalse = 0x12;
	private final static int OP_ifeq = 0x13;
	private final static int OP_ifne = 0x14;
	private final static int OP_iflt = 0x15;
	private final static int OP_ifle = 0x16;
	private final static int OP_ifgt = 0x17;
	private final static int OP_ifge = 0x18;
	private final static int OP_ifstricteq = 0x19;
	private final static int OP_ifstrictne = 0x1A;
	
	
}
